<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidPublisher;

class ScreenDensityTargeting extends \Google\Collection
{
  protected $collection_key = 'value';
  protected $alternativesType = ScreenDensity::class;
  protected $alternativesDataType = 'array';
  protected $valueType = ScreenDensity::class;
  protected $valueDataType = 'array';

  /**
   * Targeting of other sibling directories that were in the Bundle. For main
   * splits this is targeting of other main splits.
   *
   * @param ScreenDensity[] $alternatives
   */
  public function setAlternatives($alternatives)
  {
    $this->alternatives = $alternatives;
  }
  /**
   * @return ScreenDensity[]
   */
  public function getAlternatives()
  {
    return $this->alternatives;
  }
  /**
   * Value of a screen density.
   *
   * @param ScreenDensity[] $value
   */
  public function setValue($value)
  {
    $this->value = $value;
  }
  /**
   * @return ScreenDensity[]
   */
  public function getValue()
  {
    return $this->value;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ScreenDensityTargeting::class, 'Google_Service_AndroidPublisher_ScreenDensityTargeting');
