<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Calendar;

class EventReminder extends \Google\Model
{
  /**
   * The method used by this reminder. Possible values are: - "email" -
   * Reminders are sent via email.  - "popup" - Reminders are sent via a UI
   * popup.   Required when adding a reminder.
   *
   * @var string
   */
  public $method;
  /**
   * Number of minutes before the start of the event when the reminder should
   * trigger. Valid values are between 0 and 40320 (4 weeks in minutes).
   * Required when adding a reminder.
   *
   * @var int
   */
  public $minutes;

  /**
   * The method used by this reminder. Possible values are: - "email" -
   * Reminders are sent via email.  - "popup" - Reminders are sent via a UI
   * popup.   Required when adding a reminder.
   *
   * @param string $method
   */
  public function setMethod($method)
  {
    $this->method = $method;
  }
  /**
   * @return string
   */
  public function getMethod()
  {
    return $this->method;
  }
  /**
   * Number of minutes before the start of the event when the reminder should
   * trigger. Valid values are between 0 and 40320 (4 weeks in minutes).
   * Required when adding a reminder.
   *
   * @param int $minutes
   */
  public function setMinutes($minutes)
  {
    $this->minutes = $minutes;
  }
  /**
   * @return int
   */
  public function getMinutes()
  {
    return $this->minutes;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(EventReminder::class, 'Google_Service_Calendar_EventReminder');
