<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudHealthcare;

class TextSpan extends \Google\Model
{
  /**
   * The unicode codepoint index of the beginning of this span.
   *
   * @var int
   */
  public $beginOffset;
  /**
   * The original text contained in this span.
   *
   * @var string
   */
  public $content;

  /**
   * The unicode codepoint index of the beginning of this span.
   *
   * @param int $beginOffset
   */
  public function setBeginOffset($beginOffset)
  {
    $this->beginOffset = $beginOffset;
  }
  /**
   * @return int
   */
  public function getBeginOffset()
  {
    return $this->beginOffset;
  }
  /**
   * The original text contained in this span.
   *
   * @param string $content
   */
  public function setContent($content)
  {
    $this->content = $content;
  }
  /**
   * @return string
   */
  public function getContent()
  {
    return $this->content;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TextSpan::class, 'Google_Service_CloudHealthcare_TextSpan');
