<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class RoutersScopedList extends \Google\Collection
{
  protected $collection_key = 'routers';
  protected $routersType = Router::class;
  protected $routersDataType = 'array';
  protected $warningType = RoutersScopedListWarning::class;
  protected $warningDataType = '';

  /**
   * A list of routers contained in this scope.
   *
   * @param Router[] $routers
   */
  public function setRouters($routers)
  {
    $this->routers = $routers;
  }
  /**
   * @return Router[]
   */
  public function getRouters()
  {
    return $this->routers;
  }
  /**
   * Informational warning which replaces the list of routers when the list is
   * empty.
   *
   * @param RoutersScopedListWarning $warning
   */
  public function setWarning(RoutersScopedListWarning $warning)
  {
    $this->warning = $warning;
  }
  /**
   * @return RoutersScopedListWarning
   */
  public function getWarning()
  {
    return $this->warning;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RoutersScopedList::class, 'Google_Service_Compute_RoutersScopedList');
