<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DLP;

class GooglePrivacyDlpV2CreateJobTriggerRequest extends \Google\Model
{
  protected $jobTriggerType = GooglePrivacyDlpV2JobTrigger::class;
  protected $jobTriggerDataType = '';
  /**
   * Deprecated. This field has no effect.
   *
   * @var string
   */
  public $locationId;
  /**
   * The trigger id can contain uppercase and lowercase letters, numbers, and
   * hyphens; that is, it must match the regular expression: `[a-zA-Z\d-_]+`.
   * The maximum length is 100 characters. Can be empty to allow the system to
   * generate one.
   *
   * @var string
   */
  public $triggerId;

  /**
   * Required. The JobTrigger to create.
   *
   * @param GooglePrivacyDlpV2JobTrigger $jobTrigger
   */
  public function setJobTrigger(GooglePrivacyDlpV2JobTrigger $jobTrigger)
  {
    $this->jobTrigger = $jobTrigger;
  }
  /**
   * @return GooglePrivacyDlpV2JobTrigger
   */
  public function getJobTrigger()
  {
    return $this->jobTrigger;
  }
  /**
   * Deprecated. This field has no effect.
   *
   * @param string $locationId
   */
  public function setLocationId($locationId)
  {
    $this->locationId = $locationId;
  }
  /**
   * @return string
   */
  public function getLocationId()
  {
    return $this->locationId;
  }
  /**
   * The trigger id can contain uppercase and lowercase letters, numbers, and
   * hyphens; that is, it must match the regular expression: `[a-zA-Z\d-_]+`.
   * The maximum length is 100 characters. Can be empty to allow the system to
   * generate one.
   *
   * @param string $triggerId
   */
  public function setTriggerId($triggerId)
  {
    $this->triggerId = $triggerId;
  }
  /**
   * @return string
   */
  public function getTriggerId()
  {
    return $this->triggerId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GooglePrivacyDlpV2CreateJobTriggerRequest::class, 'Google_Service_DLP_GooglePrivacyDlpV2CreateJobTriggerRequest');
