<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\GamesManagement;

class PlayerName extends \Google\Model
{
  /**
   * The family name of this player. In some places, this is known as the last
   * name.
   *
   * @var string
   */
  public $familyName;
  /**
   * The given name of this player. In some places, this is known as the first
   * name.
   *
   * @var string
   */
  public $givenName;

  /**
   * The family name of this player. In some places, this is known as the last
   * name.
   *
   * @param string $familyName
   */
  public function setFamilyName($familyName)
  {
    $this->familyName = $familyName;
  }
  /**
   * @return string
   */
  public function getFamilyName()
  {
    return $this->familyName;
  }
  /**
   * The given name of this player. In some places, this is known as the first
   * name.
   *
   * @param string $givenName
   */
  public function setGivenName($givenName)
  {
    $this->givenName = $givenName;
  }
  /**
   * @return string
   */
  public function getGivenName()
  {
    return $this->givenName;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PlayerName::class, 'Google_Service_GamesManagement_PlayerName');
