<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\PeopleService;

class ListConnectionsResponse extends \Google\Collection
{
  protected $collection_key = 'connections';
  protected $connectionsType = Person::class;
  protected $connectionsDataType = 'array';
  /**
   * A token, which can be sent as `page_token` to retrieve the next page. If
   * this field is omitted, there are no subsequent pages.
   *
   * @var string
   */
  public $nextPageToken;
  /**
   * A token, which can be sent as `sync_token` to retrieve changes since the
   * last request. Request must set `request_sync_token` to return the sync
   * token. When the response is paginated, only the last page will contain
   * `nextSyncToken`.
   *
   * @var string
   */
  public $nextSyncToken;
  /**
   * The total number of items in the list without pagination.
   *
   * @var int
   */
  public $totalItems;
  /**
   * **DEPRECATED** (Please use totalItems) The total number of people in the
   * list without pagination.
   *
   * @deprecated
   * @var int
   */
  public $totalPeople;

  /**
   * The list of people that the requestor is connected to.
   *
   * @param Person[] $connections
   */
  public function setConnections($connections)
  {
    $this->connections = $connections;
  }
  /**
   * @return Person[]
   */
  public function getConnections()
  {
    return $this->connections;
  }
  /**
   * A token, which can be sent as `page_token` to retrieve the next page. If
   * this field is omitted, there are no subsequent pages.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * A token, which can be sent as `sync_token` to retrieve changes since the
   * last request. Request must set `request_sync_token` to return the sync
   * token. When the response is paginated, only the last page will contain
   * `nextSyncToken`.
   *
   * @param string $nextSyncToken
   */
  public function setNextSyncToken($nextSyncToken)
  {
    $this->nextSyncToken = $nextSyncToken;
  }
  /**
   * @return string
   */
  public function getNextSyncToken()
  {
    return $this->nextSyncToken;
  }
  /**
   * The total number of items in the list without pagination.
   *
   * @param int $totalItems
   */
  public function setTotalItems($totalItems)
  {
    $this->totalItems = $totalItems;
  }
  /**
   * @return int
   */
  public function getTotalItems()
  {
    return $this->totalItems;
  }
  /**
   * **DEPRECATED** (Please use totalItems) The total number of people in the
   * list without pagination.
   *
   * @deprecated
   * @param int $totalPeople
   */
  public function setTotalPeople($totalPeople)
  {
    $this->totalPeople = $totalPeople;
  }
  /**
   * @deprecated
   * @return int
   */
  public function getTotalPeople()
  {
    return $this->totalPeople;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ListConnectionsResponse::class, 'Google_Service_PeopleService_ListConnectionsResponse');
