<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecureSourceManager;

class PullRequest extends \Google\Model
{
  /**
   * Unspecified.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * An open pull request.
   */
  public const STATE_OPEN = 'OPEN';
  /**
   * A closed pull request.
   */
  public const STATE_CLOSED = 'CLOSED';
  /**
   * A merged pull request.
   */
  public const STATE_MERGED = 'MERGED';
  protected $baseType = Branch::class;
  protected $baseDataType = '';
  /**
   * Optional. The pull request body. Provides a detailed description of the
   * changes.
   *
   * @var string
   */
  public $body;
  /**
   * Output only. Close timestamp (if closed or merged). Cleared when pull
   * request is re-opened.
   *
   * @var string
   */
  public $closeTime;
  /**
   * Output only. Creation timestamp.
   *
   * @var string
   */
  public $createTime;
  protected $headType = Branch::class;
  protected $headDataType = '';
  /**
   * Output only. A unique identifier for a PullRequest. The number appended at
   * the end is generated by the server. Format: `projects/{project}/locations/{
   * location}/repositories/{repository}/pullRequests/{pull_request_id}`
   *
   * @var string
   */
  public $name;
  /**
   * Output only. State of the pull request (open, closed or merged).
   *
   * @var string
   */
  public $state;
  /**
   * Required. The pull request title.
   *
   * @var string
   */
  public $title;
  /**
   * Output only. Last updated timestamp.
   *
   * @var string
   */
  public $updateTime;

  /**
   * Required. The branch to merge changes in.
   *
   * @param Branch $base
   */
  public function setBase(Branch $base)
  {
    $this->base = $base;
  }
  /**
   * @return Branch
   */
  public function getBase()
  {
    return $this->base;
  }
  /**
   * Optional. The pull request body. Provides a detailed description of the
   * changes.
   *
   * @param string $body
   */
  public function setBody($body)
  {
    $this->body = $body;
  }
  /**
   * @return string
   */
  public function getBody()
  {
    return $this->body;
  }
  /**
   * Output only. Close timestamp (if closed or merged). Cleared when pull
   * request is re-opened.
   *
   * @param string $closeTime
   */
  public function setCloseTime($closeTime)
  {
    $this->closeTime = $closeTime;
  }
  /**
   * @return string
   */
  public function getCloseTime()
  {
    return $this->closeTime;
  }
  /**
   * Output only. Creation timestamp.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Immutable. The branch containing the changes to be merged.
   *
   * @param Branch $head
   */
  public function setHead(Branch $head)
  {
    $this->head = $head;
  }
  /**
   * @return Branch
   */
  public function getHead()
  {
    return $this->head;
  }
  /**
   * Output only. A unique identifier for a PullRequest. The number appended at
   * the end is generated by the server. Format: `projects/{project}/locations/{
   * location}/repositories/{repository}/pullRequests/{pull_request_id}`
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Output only. State of the pull request (open, closed or merged).
   *
   * Accepted values: STATE_UNSPECIFIED, OPEN, CLOSED, MERGED
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * Required. The pull request title.
   *
   * @param string $title
   */
  public function setTitle($title)
  {
    $this->title = $title;
  }
  /**
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }
  /**
   * Output only. Last updated timestamp.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PullRequest::class, 'Google_Service_SecureSourceManager_PullRequest');
