<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecurityCommandCenter;

class Vulnerability extends \Google\Collection
{
  protected $collection_key = 'cwes';
  protected $cveType = Cve::class;
  protected $cveDataType = '';
  protected $cwesType = Cwe::class;
  protected $cwesDataType = 'array';
  protected $fixedPackageType = Package::class;
  protected $fixedPackageDataType = '';
  protected $offendingPackageType = Package::class;
  protected $offendingPackageDataType = '';
  /**
   * Provider provided risk_score based on multiple factors. The higher the risk
   * score, the more risky the vulnerability is.
   *
   * @var string
   */
  public $providerRiskScore;
  /**
   * Represents whether the vulnerability is reachable (detected via static
   * analysis)
   *
   * @var bool
   */
  public $reachable;
  protected $securityBulletinType = SecurityBulletin::class;
  protected $securityBulletinDataType = '';

  /**
   * CVE stands for Common Vulnerabilities and Exposures
   * (https://cve.mitre.org/about/)
   *
   * @param Cve $cve
   */
  public function setCve(Cve $cve)
  {
    $this->cve = $cve;
  }
  /**
   * @return Cve
   */
  public function getCve()
  {
    return $this->cve;
  }
  /**
   * Represents one or more Common Weakness Enumeration (CWE) information on
   * this vulnerability.
   *
   * @param Cwe[] $cwes
   */
  public function setCwes($cwes)
  {
    $this->cwes = $cwes;
  }
  /**
   * @return Cwe[]
   */
  public function getCwes()
  {
    return $this->cwes;
  }
  /**
   * The fixed package is relevant to the finding.
   *
   * @param Package $fixedPackage
   */
  public function setFixedPackage(Package $fixedPackage)
  {
    $this->fixedPackage = $fixedPackage;
  }
  /**
   * @return Package
   */
  public function getFixedPackage()
  {
    return $this->fixedPackage;
  }
  /**
   * The offending package is relevant to the finding.
   *
   * @param Package $offendingPackage
   */
  public function setOffendingPackage(Package $offendingPackage)
  {
    $this->offendingPackage = $offendingPackage;
  }
  /**
   * @return Package
   */
  public function getOffendingPackage()
  {
    return $this->offendingPackage;
  }
  /**
   * Provider provided risk_score based on multiple factors. The higher the risk
   * score, the more risky the vulnerability is.
   *
   * @param string $providerRiskScore
   */
  public function setProviderRiskScore($providerRiskScore)
  {
    $this->providerRiskScore = $providerRiskScore;
  }
  /**
   * @return string
   */
  public function getProviderRiskScore()
  {
    return $this->providerRiskScore;
  }
  /**
   * Represents whether the vulnerability is reachable (detected via static
   * analysis)
   *
   * @param bool $reachable
   */
  public function setReachable($reachable)
  {
    $this->reachable = $reachable;
  }
  /**
   * @return bool
   */
  public function getReachable()
  {
    return $this->reachable;
  }
  /**
   * The security bulletin is relevant to this finding.
   *
   * @param SecurityBulletin $securityBulletin
   */
  public function setSecurityBulletin(SecurityBulletin $securityBulletin)
  {
    $this->securityBulletin = $securityBulletin;
  }
  /**
   * @return SecurityBulletin
   */
  public function getSecurityBulletin()
  {
    return $this->securityBulletin;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Vulnerability::class, 'Google_Service_SecurityCommandCenter_Vulnerability');
