<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\YouTube;

class ResourceId extends \Google\Model
{
  /**
   * The ID that YouTube uses to uniquely identify the referred resource, if
   * that resource is a channel. This property is only present if the
   * resourceId.kind value is youtube#channel.
   *
   * @var string
   */
  public $channelId;
  /**
   * The type of the API resource.
   *
   * @var string
   */
  public $kind;
  /**
   * The ID that YouTube uses to uniquely identify the referred resource, if
   * that resource is a playlist. This property is only present if the
   * resourceId.kind value is youtube#playlist.
   *
   * @var string
   */
  public $playlistId;
  /**
   * The ID that YouTube uses to uniquely identify the referred resource, if
   * that resource is a video. This property is only present if the
   * resourceId.kind value is youtube#video.
   *
   * @var string
   */
  public $videoId;

  /**
   * The ID that YouTube uses to uniquely identify the referred resource, if
   * that resource is a channel. This property is only present if the
   * resourceId.kind value is youtube#channel.
   *
   * @param string $channelId
   */
  public function setChannelId($channelId)
  {
    $this->channelId = $channelId;
  }
  /**
   * @return string
   */
  public function getChannelId()
  {
    return $this->channelId;
  }
  /**
   * The type of the API resource.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * The ID that YouTube uses to uniquely identify the referred resource, if
   * that resource is a playlist. This property is only present if the
   * resourceId.kind value is youtube#playlist.
   *
   * @param string $playlistId
   */
  public function setPlaylistId($playlistId)
  {
    $this->playlistId = $playlistId;
  }
  /**
   * @return string
   */
  public function getPlaylistId()
  {
    return $this->playlistId;
  }
  /**
   * The ID that YouTube uses to uniquely identify the referred resource, if
   * that resource is a video. This property is only present if the
   * resourceId.kind value is youtube#video.
   *
   * @param string $videoId
   */
  public function setVideoId($videoId)
  {
    $this->videoId = $videoId;
  }
  /**
   * @return string
   */
  public function getVideoId()
  {
    return $this->videoId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ResourceId::class, 'Google_Service_YouTube_ResourceId');
