<?php
require_once 'connect.php';

try {
    $conn = getDatabaseConnection();

    $query = "SELECT id, name, slug FROM tags";
    $stmt = $conn->prepare($query);
    $stmt->execute();
    
    $tags = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $tags[] = [
            'id' => (int)$row['id'],
            'name' => $row['name'],
            'slug' => $row['slug']
        ];
    }
    
    http_response_code(200);
    echo json_encode($tags);
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Failed to fetch tags",
        "error" => $e->getMessage()
    ]);
}
?>