<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudTalentSolution;

class Tenant extends \Google\Model
{
  /**
   * Required. Client side tenant identifier, used to uniquely identify the
   * tenant. The maximum number of allowed characters is 255.
   *
   * @var string
   */
  public $externalId;
  /**
   * Required during tenant update. The resource name for a tenant. This is
   * generated by the service when a tenant is created. The format is
   * "projects/{project_id}/tenants/{tenant_id}", for example,
   * "projects/foo/tenants/bar".
   *
   * @var string
   */
  public $name;

  /**
   * Required. Client side tenant identifier, used to uniquely identify the
   * tenant. The maximum number of allowed characters is 255.
   *
   * @param string $externalId
   */
  public function setExternalId($externalId)
  {
    $this->externalId = $externalId;
  }
  /**
   * @return string
   */
  public function getExternalId()
  {
    return $this->externalId;
  }
  /**
   * Required during tenant update. The resource name for a tenant. This is
   * generated by the service when a tenant is created. The format is
   * "projects/{project_id}/tenants/{tenant_id}", for example,
   * "projects/foo/tenants/bar".
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Tenant::class, 'Google_Service_CloudTalentSolution_Tenant');
