<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contactcenterinsights;

class GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest extends \Google\Model
{
  protected $qaQuestionTagType = GoogleCloudContactcenterinsightsV1QaQuestionTag::class;
  protected $qaQuestionTagDataType = '';
  /**
   * Optional. The list of fields to be updated. All possible fields can be
   * updated by passing `*`, or a subset of the following updateable fields can
   * be provided: * `qa_question_tag_name` - the name of the tag *
   * `qa_question_ids` - the list of questions the tag applies to
   *
   * @var string
   */
  public $updateMask;

  /**
   * Required. The QaQuestionTag to update.
   *
   * @param GoogleCloudContactcenterinsightsV1QaQuestionTag $qaQuestionTag
   */
  public function setQaQuestionTag(GoogleCloudContactcenterinsightsV1QaQuestionTag $qaQuestionTag)
  {
    $this->qaQuestionTag = $qaQuestionTag;
  }
  /**
   * @return GoogleCloudContactcenterinsightsV1QaQuestionTag
   */
  public function getQaQuestionTag()
  {
    return $this->qaQuestionTag;
  }
  /**
   * Optional. The list of fields to be updated. All possible fields can be
   * updated by passing `*`, or a subset of the following updateable fields can
   * be provided: * `qa_question_tag_name` - the name of the tag *
   * `qa_question_ids` - the list of questions the tag applies to
   *
   * @param string $updateMask
   */
  public function setUpdateMask($updateMask)
  {
    $this->updateMask = $updateMask;
  }
  /**
   * @return string
   */
  public function getUpdateMask()
  {
    return $this->updateMask;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest::class, 'Google_Service_Contactcenterinsights_GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest');
