<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Container;

class MeshCertificates extends \Google\Model
{
  /**
   * enable_certificates controls issuance of workload mTLS certificates. If
   * set, the GKE Workload Identity Certificates controller and node agent will
   * be deployed in the cluster, which can then be configured by creating a
   * WorkloadCertificateConfig Custom Resource. Requires Workload Identity
   * (workload_pool must be non-empty).
   *
   * @var bool
   */
  public $enableCertificates;

  /**
   * enable_certificates controls issuance of workload mTLS certificates. If
   * set, the GKE Workload Identity Certificates controller and node agent will
   * be deployed in the cluster, which can then be configured by creating a
   * WorkloadCertificateConfig Custom Resource. Requires Workload Identity
   * (workload_pool must be non-empty).
   *
   * @param bool $enableCertificates
   */
  public function setEnableCertificates($enableCertificates)
  {
    $this->enableCertificates = $enableCertificates;
  }
  /**
   * @return bool
   */
  public function getEnableCertificates()
  {
    return $this->enableCertificates;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(MeshCertificates::class, 'Google_Service_Container_MeshCertificates');
