<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Keep;

class Section extends \Google\Model
{
  protected $listType = ListContent::class;
  protected $listDataType = '';
  protected $textType = TextContent::class;
  protected $textDataType = '';

  /**
   * Used if this section's content is a list.
   *
   * @param ListContent $list
   */
  public function setList(ListContent $list)
  {
    $this->list = $list;
  }
  /**
   * @return ListContent
   */
  public function getList()
  {
    return $this->list;
  }
  /**
   * Used if this section's content is a block of text. The length of the text
   * content must be less than 20,000 characters.
   *
   * @param TextContent $text
   */
  public function setText(TextContent $text)
  {
    $this->text = $text;
  }
  /**
   * @return TextContent
   */
  public function getText()
  {
    return $this->text;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Section::class, 'Google_Service_Keep_Section');
