<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\NetworkServices;

class HttpRouteStatefulSessionAffinityPolicy extends \Google\Model
{
  /**
   * Required. The cookie TTL value for the Set-Cookie header generated by the
   * data plane. The lifetime of the cookie may be set to a value from 0 to
   * 86400 seconds (24 hours) inclusive. Set this to 0s to use a session cookie
   * and disable cookie expiration.
   *
   * @var string
   */
  public $cookieTtl;

  /**
   * Required. The cookie TTL value for the Set-Cookie header generated by the
   * data plane. The lifetime of the cookie may be set to a value from 0 to
   * 86400 seconds (24 hours) inclusive. Set this to 0s to use a session cookie
   * and disable cookie expiration.
   *
   * @param string $cookieTtl
   */
  public function setCookieTtl($cookieTtl)
  {
    $this->cookieTtl = $cookieTtl;
  }
  /**
   * @return string
   */
  public function getCookieTtl()
  {
    return $this->cookieTtl;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(HttpRouteStatefulSessionAffinityPolicy::class, 'Google_Service_NetworkServices_HttpRouteStatefulSessionAffinityPolicy');
