<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\YouTube;

class I18nRegionSnippet extends \Google\Model
{
  /**
   * The region code as a 2-letter ISO country code.
   *
   * @var string
   */
  public $gl;
  /**
   * The human-readable name of the region.
   *
   * @var string
   */
  public $name;

  /**
   * The region code as a 2-letter ISO country code.
   *
   * @param string $gl
   */
  public function setGl($gl)
  {
    $this->gl = $gl;
  }
  /**
   * @return string
   */
  public function getGl()
  {
    return $this->gl;
  }
  /**
   * The human-readable name of the region.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(I18nRegionSnippet::class, 'Google_Service_YouTube_I18nRegionSnippet');
