<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataflow;

class FloatingPointMean extends \Google\Model
{
  protected $countType = SplitInt64::class;
  protected $countDataType = '';
  /**
   * The sum of all values being aggregated.
   *
   * @var 
   */
  public $sum;

  /**
   * The number of values being aggregated.
   *
   * @param SplitInt64 $count
   */
  public function setCount(SplitInt64 $count)
  {
    $this->count = $count;
  }
  /**
   * @return SplitInt64
   */
  public function getCount()
  {
    return $this->count;
  }
  public function setSum($sum)
  {
    $this->sum = $sum;
  }
  public function getSum()
  {
    return $this->sum;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(FloatingPointMean::class, 'Google_Service_Dataflow_FloatingPointMean');
