<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ManufacturerCenter;

class ProductDetail extends \Google\Model
{
  /**
   * The name of the attribute.
   *
   * @var string
   */
  public $attributeName;
  /**
   * The value of the attribute.
   *
   * @var string
   */
  public $attributeValue;
  /**
   * A short section name that can be reused between multiple product details.
   *
   * @var string
   */
  public $sectionName;

  /**
   * The name of the attribute.
   *
   * @param string $attributeName
   */
  public function setAttributeName($attributeName)
  {
    $this->attributeName = $attributeName;
  }
  /**
   * @return string
   */
  public function getAttributeName()
  {
    return $this->attributeName;
  }
  /**
   * The value of the attribute.
   *
   * @param string $attributeValue
   */
  public function setAttributeValue($attributeValue)
  {
    $this->attributeValue = $attributeValue;
  }
  /**
   * @return string
   */
  public function getAttributeValue()
  {
    return $this->attributeValue;
  }
  /**
   * A short section name that can be reused between multiple product details.
   *
   * @param string $sectionName
   */
  public function setSectionName($sectionName)
  {
    $this->sectionName = $sectionName;
  }
  /**
   * @return string
   */
  public function getSectionName()
  {
    return $this->sectionName;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ProductDetail::class, 'Google_Service_ManufacturerCenter_ProductDetail');
