<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\PeopleService;

class BatchCreateContactsResponse extends \Google\Collection
{
  protected $collection_key = 'createdPeople';
  protected $createdPeopleType = PersonResponse::class;
  protected $createdPeopleDataType = 'array';

  /**
   * The contacts that were created, unless the request `read_mask` is empty.
   *
   * @param PersonResponse[] $createdPeople
   */
  public function setCreatedPeople($createdPeople)
  {
    $this->createdPeople = $createdPeople;
  }
  /**
   * @return PersonResponse[]
   */
  public function getCreatedPeople()
  {
    return $this->createdPeople;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BatchCreateContactsResponse::class, 'Google_Service_PeopleService_BatchCreateContactsResponse');
