<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Vision;

class GoogleCloudVisionV1p3beta1WebDetection extends \Google\Collection
{
  protected $collection_key = 'webEntities';
  protected $bestGuessLabelsType = GoogleCloudVisionV1p3beta1WebDetectionWebLabel::class;
  protected $bestGuessLabelsDataType = 'array';
  protected $fullMatchingImagesType = GoogleCloudVisionV1p3beta1WebDetectionWebImage::class;
  protected $fullMatchingImagesDataType = 'array';
  protected $pagesWithMatchingImagesType = GoogleCloudVisionV1p3beta1WebDetectionWebPage::class;
  protected $pagesWithMatchingImagesDataType = 'array';
  protected $partialMatchingImagesType = GoogleCloudVisionV1p3beta1WebDetectionWebImage::class;
  protected $partialMatchingImagesDataType = 'array';
  protected $visuallySimilarImagesType = GoogleCloudVisionV1p3beta1WebDetectionWebImage::class;
  protected $visuallySimilarImagesDataType = 'array';
  protected $webEntitiesType = GoogleCloudVisionV1p3beta1WebDetectionWebEntity::class;
  protected $webEntitiesDataType = 'array';

  /**
   * The service's best guess as to the topic of the request image. Inferred
   * from similar images on the open web.
   *
   * @param GoogleCloudVisionV1p3beta1WebDetectionWebLabel[] $bestGuessLabels
   */
  public function setBestGuessLabels($bestGuessLabels)
  {
    $this->bestGuessLabels = $bestGuessLabels;
  }
  /**
   * @return GoogleCloudVisionV1p3beta1WebDetectionWebLabel[]
   */
  public function getBestGuessLabels()
  {
    return $this->bestGuessLabels;
  }
  /**
   * Fully matching images from the Internet. Can include resized copies of the
   * query image.
   *
   * @param GoogleCloudVisionV1p3beta1WebDetectionWebImage[] $fullMatchingImages
   */
  public function setFullMatchingImages($fullMatchingImages)
  {
    $this->fullMatchingImages = $fullMatchingImages;
  }
  /**
   * @return GoogleCloudVisionV1p3beta1WebDetectionWebImage[]
   */
  public function getFullMatchingImages()
  {
    return $this->fullMatchingImages;
  }
  /**
   * Web pages containing the matching images from the Internet.
   *
   * @param GoogleCloudVisionV1p3beta1WebDetectionWebPage[] $pagesWithMatchingImages
   */
  public function setPagesWithMatchingImages($pagesWithMatchingImages)
  {
    $this->pagesWithMatchingImages = $pagesWithMatchingImages;
  }
  /**
   * @return GoogleCloudVisionV1p3beta1WebDetectionWebPage[]
   */
  public function getPagesWithMatchingImages()
  {
    return $this->pagesWithMatchingImages;
  }
  /**
   * Partial matching images from the Internet. Those images are similar enough
   * to share some key-point features. For example an original image will likely
   * have partial matching for its crops.
   *
   * @param GoogleCloudVisionV1p3beta1WebDetectionWebImage[] $partialMatchingImages
   */
  public function setPartialMatchingImages($partialMatchingImages)
  {
    $this->partialMatchingImages = $partialMatchingImages;
  }
  /**
   * @return GoogleCloudVisionV1p3beta1WebDetectionWebImage[]
   */
  public function getPartialMatchingImages()
  {
    return $this->partialMatchingImages;
  }
  /**
   * The visually similar image results.
   *
   * @param GoogleCloudVisionV1p3beta1WebDetectionWebImage[] $visuallySimilarImages
   */
  public function setVisuallySimilarImages($visuallySimilarImages)
  {
    $this->visuallySimilarImages = $visuallySimilarImages;
  }
  /**
   * @return GoogleCloudVisionV1p3beta1WebDetectionWebImage[]
   */
  public function getVisuallySimilarImages()
  {
    return $this->visuallySimilarImages;
  }
  /**
   * Deduced entities from similar images on the Internet.
   *
   * @param GoogleCloudVisionV1p3beta1WebDetectionWebEntity[] $webEntities
   */
  public function setWebEntities($webEntities)
  {
    $this->webEntities = $webEntities;
  }
  /**
   * @return GoogleCloudVisionV1p3beta1WebDetectionWebEntity[]
   */
  public function getWebEntities()
  {
    return $this->webEntities;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudVisionV1p3beta1WebDetection::class, 'Google_Service_Vision_GoogleCloudVisionV1p3beta1WebDetection');
